%**************************************************************************
% Function Name  : VNgetADORID
% Description    : 
%  Converts a ADOR register 3 to 5 letter acronym into a register number. 
%  This allows for the user to easily requests a known type of data without
%  having to remember the associated register number.
%
% Input(s)       : ADOR     -> register acronym
% Output(s)      : regID    -> register ID
%**************************************************************************
% Examples:
%
%   s = VNserial('COM8');
%
%   regID = VNgetADORID('QTN');
%
%   VNwriteregister(s, 'ADOR' regID);
%
% ------------- VectorNav Technologies, LLC -------------------------------
% This file is property of VectorNav Technologies and cannot be used,
% copied or distributed without the written consent of VectorNav
% Technologies. 
% -------------------------------------------------------------------------
function regID = VNgetADORID(ADOR)

regID = 1;

%Set the ADOR
if strcmp(ADOR, 'YPR')
    regID = 1;
elseif strcmp(ADOR, 'QTN')
    regID = 2;
elseif strcmp(ADOR, 'QTM')
    regID = 3;
elseif strcmp(ADOR, 'QTA')
    regID = 4;
elseif strcmp(ADOR, 'QTR')
    regID = 5;
elseif strcmp(ADOR, 'QMA')
    regID = 6;
elseif strcmp(ADOR, 'QAR')
    regID = 7;
elseif strcmp(ADOR, 'QMR')
    regID = 8;
elseif strcmp(ADOR, 'DCM')
    regID = 9;
elseif strcmp(ADOR, 'MAG')
    regID = 10;
elseif strcmp(ADOR, 'ACC')
    regID = 11;
elseif strcmp(ADOR, 'GYR')
    regID = 12;
elseif strcmp(ADOR, 'MAR')
    regID = 13;
elseif strcmp(ADOR, 'YMR')
    regID = 14;
elseif strcmp(ADOR, 'RAW')
    regID = 252;
elseif strcmp(ADOR, 'CMV')
    regID = 253;
elseif strcmp(ADOR, 'STV')
    regID = 254;
elseif strcmp(ADOR, 'COV')
    regID = 255;
end