%**************************************************************************
% Function Name  : VNplotADORNoise
% Description    : 
%  Plot the zero mean noise of the data captured by the VNrecordADOR
% function. Pass the data received along with the ADOR register type, 
% and this function will subtract the zero mean for each channel, then 
% plot the results along with labeled and titled figures.
%
% Input(s)       : ADOR       -> register acronym
%                : sampleRate -> sample rate in Hz
%                : numSec     -> number of seconds to record
% Output(s)      : None
%**************************************************************************
% Examples:
%
%   s = VNserial('COM8');
%
%   data = VNrecordADOR(s, 'YPR', 100, 10); %record @ 100Hz for 10s
%
%   VNplotADORNoise(data, 'YPR', 100);
%
% ------------- VectorNav Technologies, LLC -------------------------------
% This file is property of VectorNav Technologies and cannot be used,
% copied or distributed without the written consent of VectorNav
% Technologies. 
% -------------------------------------------------------------------------
function VNplotADORNoise(data, ADOR, sampleRate)

%Subtract mean
dm = zeros(size(data));
for i=1:size(data,2)
    dm(:,i) = data(:,i) - mean(data(:,i));
end

VNplotADOR(dm, ADOR, sampleRate, 'Noise on ');





