%**************************************************************************
% Function Name  : VNregID
% Description    : 
%  Converts a register 3 to 5 letter acronym into a register number. This
%  allows for the user to easily requests a known type of data without
%  having to remember the associated register number.
%
% Input(s)       : register acronym
% Output(s)      : regID -> register ID
%**************************************************************************
% Examples:
%
%   s = VNserial('COM8');
%
%   regID = VNregID('QTN');
%
%   vals = VNreadregister(s, regID);
%
% ------------- VectorNav Technologies, LLC -------------------------------
% This file is property of VectorNav Technologies and cannot be used,
% copied or distributed without the written consent of VectorNav
% Technologies. 
% -------------------------------------------------------------------------
function regID = VNregID(regName)


if strcmp(regName, 'MODEL')
    regID = 1;
elseif strcmp(regName, 'HWREV')
    regID = 2;
elseif strcmp(regName, 'SN')
    regID = 3;
elseif strcmp(regName, 'FWVER')
    regID = 4;
elseif strcmp(regName, 'BAUD')
    regID = 5;
elseif strcmp(regName, 'ADOR')
    regID = 6;
elseif strcmp(regName, 'ADOF')
    regID = 7;
elseif strcmp(regName, 'YPR')
    regID = 8;
elseif strcmp(regName, 'QTN')
    regID = 9;
elseif strcmp(regName, 'QTM')
    regID = 10;
elseif strcmp(regName, 'QTA')
    regID = 11;
elseif strcmp(regName, 'QTR')
    regID = 12;
elseif strcmp(regName, 'QMA')
    regID = 13;
elseif strcmp(regName, 'QAR')
    regID = 14;
elseif strcmp(regName, 'QMR')
    regID = 15;
elseif strcmp(regName, 'DCM')
    regID = 16;
elseif strcmp(regName, 'MAG')
    regID = 17;
elseif strcmp(regName, 'ACC')
    regID = 18;
elseif strcmp(regName, 'GYR')
    regID = 19;
elseif strcmp(regName, 'MAR')
    regID = 20;
elseif strcmp(regName, 'REF')
    regID = 21;
elseif strcmp(regName, 'VAR')
    regID = 22;
elseif strcmp(regName, 'HSI')
    regID = 23;
elseif strcmp(regName, 'DTP')
    regID = 24;
elseif strcmp(regName, 'ACT')
    regID = 25;
elseif strcmp(regName, 'RFR')
    regID = 26;
elseif strcmp(regName, 'YMR')
    regID = 27;
elseif strcmp(regName, 'ACG')
    regID = 28;
elseif strcmp(regName, 'YCM')
    regID = 29;
elseif strcmp(regName, 'RAV')
    regID = 250;
elseif strcmp(regName, 'RAW')
    regID = 251;
elseif strcmp(regName, 'CMV')
    regID = 252;
elseif strcmp(regName, 'STV')
    regID = 253;
elseif strcmp(regName, 'COV')
    regID = 254;
elseif strcmp(regName, 'CAL')
    regID = 255;
end