%**************************************************************************
% Function Name  : VNsetbaudrate
% Description    : 
%  VN100_SetBaudRate sets the baud rate of the sensor, then changes the
%   baud rate of the COM port to match.
%
% Input(s)       : VNserial -> serial port object
%                : newBaud  -> new requested baud rate
% Output(s)      : None
%**************************************************************************
%   Examples:
%   
%   Se the baud rate to 115200.
%
%   s = VNserial('COM8');
%   VNsetbaudrate(s, 115200); %Change baud rate to 9600
%
% ------------- VectorNav Technologies, LLC -------------------------------
% This file is property of VectorNav Technologies and cannot be used,
% copied or distributed without the written consent of VectorNav
% Technologies. 
% -------------------------------------------------------------------------
function VNsetbaudrate(VNserial, newBaud)

%Turn off ADOR
VNwriteregister(VNserial, 6, 0);

%Wait 250ms
pause(0.25);

%Clear input
VNclearbuffer(VNserial);

%Write new baud to register
s = sprintf('VNWRG,5,%i', newBaud);

%Send command
VNprintf(VNserial, s);
pause(0.25);
VNserial.BaudRate = newBaud;
pause(0.25);



