%**************************************************************************
% Function Name  : VNwriteregister
% Description    : 
%  Write to the contents of the given register on the VN-100. The register
%  can be given as a register ID number or as a 3-5 letter acronym found in
%  in the VNregID function.
%
% Input(s)       : VNserial -> serial port object
%                : regID    -> register ID or acronym
%                : values   -> values to write to the register
%                : optional -> optional parameters      
% Output(s)      : response -> The contents of the requested register as a
%                              1XN array.
%**************************************************************************
%   Examples:
%   
%   Set the Hard/Soft Iron compensation register (HSI) to the default state
%   of an identity matrix for soft iron and zero for hard iron.
%
%   s = serial('COM8', 'BaudRate', 115200, 'DataBits', 8);
%   fopen(VNserial);
%   
%   %Write to register 23
%   VNwriteRegister(s, 23, [1 0 0 0 1 0 0 0 1 0 0 0]);
%
%   %Alternatively you can use the register acronym
%   VNwriteRegister(s, 'HSI', [1 0 0 0 1 0 0 0 1 0 0 0]);

% ------------- VectorNav Technologies, LLC -------------------------------
% This file is property of VectorNav Technologies and cannot be used,
% copied or distributed without the written consent of VectorNav
% Technologies. 
% -------------------------------------------------------------------------
function response = VNwriteregister(VNserial, regID, values, optional)

%Convert regID to reg ID number if string
if isstr(regID)
    regID = VNregID(regID);
end

%Create one string for entire command
if ischar(values)
    if nargin < 4
        s = sprintf('VNWRG,%i,%s', regID, values);
    else
        s = sprintf('VNWRG,%i,%s,%i', regID, values, optional);
    end
else
    params = '';
    for i=1:length(values)
        params = [params sprintf(',%1.9G', values(i))];
    end
    if nargin >= 4
        s = sprintf('VNWRG,%i%s,%i', regID, params, optional);
    else
        s = sprintf('VNWRG,%i%s', regID, params);
    end
end

%Clear input buffer
VNclearbuffer(VNserial);

%Send command
VNprintf(VNserial, s);

%Wait for response
response = VNverifyresponse(VNserial, s);  
