//*****************************************************************************************
//                           LICENSE INFORMATION
//*****************************************************************************************
//   Fieldforce TCM-Demo Version 1.0.0.0
//
//   Communication and debug example for serial port communication to TCM module
//
//   Copyright (C) 2012  
//   Jrgen Goldmann
//   Email: j.goldmann@dlg.org
//   
//
//   This program is free software: you can redistribute it and/or modify
//   it under the terms of the GNU General Public License as published by
//   the Free Software Foundation, either version 3 of the License, or
//   (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program.  If not, see <http://www.gnu.org/licenses/>.
//*****************************************************************************************

using System;
using System.Windows.Forms;

namespace PCComm
{
    public partial class frmMain : Form
    {
        CommunicationManager comm = new CommunicationManager();
        TCMprotocol prot = new TCMprotocol();

        string transType = string.Empty;
        public frmMain()
        {
            InitializeComponent();
        }

        private void frmMain_Load(object sender, EventArgs e)
        {
           LoadValues();
           SetDefaults();
           SetControlState();
           byte [] ba = new byte [] {0x00,0x05,0x01}; // Beispiel zum Testen der CRC
           CRC16 cr = new CRC16(0);

            //00 15 
            //05  FrameID : kDataResponse
            //03  count 
            //05  43 0C 81 02 kHeading Float32 (degrees)
            //18  40 E5 CE 90 kPAngle Float32  
            //19  40 69 BC 9A kRAngle Float32
            //50 E5           
           
           byte [] bcc = cr.ComputeHighLowByte(ba);
           uint x = cr.Compute(ba);
           byte[] baval = new byte[] { 0x43, 0x0C, 0x81, 0x02 };
           //float sval = CRC16.toFloat32(baval);
        }

        private void cmdOpen_Click(object sender, EventArgs e)
        {
            comm.PortName = cboPort.Text; // by JG:
            comm.Parity = cboParity.Text;
            comm.StopBits = cboStop.Text;
            comm.DataBits = cboData.Text;
            comm.BaudRate = cboBaud.Text;
            comm.DisplayWindow = rtbDisplay;

           

            

            prot.SetTextBoxes(textBoxHeading, textBoxPitch, textBoxRoll);
            prot.SetTrackBar(trackBar1, trackBar2);
            prot.SetRichTextbox(rtbDisplay);

            comm.SetCustomEventHandler(prot.ReadValues);

            comm.OpenPort();
            cmdOpen.Enabled = false;
            cmdClose.Enabled = true;
            
            
        }

        /// <summary>
        /// Method to initialize serial port
        /// values to standard defaults
        /// </summary>
        private void SetDefaults()
        {
            try
            {
                cboPort.SelectedIndex = 0;
                cboBaud.SelectedText = "38400";
                cboParity.SelectedIndex = 0;
                cboStop.SelectedIndex = 1;
                cboData.SelectedIndex = 1;
            }
            catch
            {

            }
        }

        /// <summary>
        /// methos to load our serial
        /// port option values
        /// </summary>
        private void LoadValues()
        {

            comm.SetPortNameValues(cboPort);
            comm.SetParityValues(cboParity);
            comm.SetStopBitValues(cboStop);
            comm.CurrentTransmissionType = PCComm.CommunicationManager.TransmissionType.Hex;
        }

        /// <summary>
        /// method to set the state of controls
        /// when the form first loads
        /// </summary>
        private void SetControlState()
        {
            //rdoHex.Checked = true;
          
            cmdClose.Enabled = false;
        }

        
        private void rdoHex_CheckedChanged(object sender, EventArgs e)
        {
            //if (rdoHex.Checked == true)
            //{
                comm.CurrentTransmissionType = PCComm.CommunicationManager.TransmissionType.Hex;
            //}
            //else
            //{
            //    comm.CurrentTransmissionType = PCComm.CommunicationManager.TransmissionType.Text;
            //}
        }

        private void cmdClose_Click(object sender, EventArgs e)
        {
           
            System.Threading.Thread.Sleep(300);
            comm.ClosePort();
            
                cmdClose.Enabled = false;
               
                cmdOpen.Enabled = true;
           
        }

        
        private void clearToolStripMenuItem_Click(object sender, EventArgs e)
        {
            rtbDisplay.Clear();
        }

       
        private void SetPushInterval_Click(object sender, EventArgs e)
        {
            // ID 24 (d) kSetAcqParams = set Push-Rate 
           
                                      //   ID   0=Push 0=no Filter Flush, 0000=SensorAcqTime, 0000=IntervalRespTime 
            byte[] ba1 = new byte[]   {    24,  0,     0,                 0,0,0,0,            0,0,0,0};

            // fill wiht IntervalResTime from Textbox
            Single sVal = 0;
            Single.TryParse(textBoxPushRate.Text, out sVal);
            byte[] bVal4 = TCMprotocol.Float32ToByteArray(sVal);
            Array.Copy(bVal4, 0, ba1, 7, 4);
            comm.WriteData(TCMprotocol.CreateTCMDatagram(ba1));
           

            //// ID 21(d) kStartIntervalMode = Push-Mode ON
            ba1 = new byte[] {21};

            comm.WriteData(TCMprotocol.CreateTCMDatagram(ba1));
        }

        private void textBoxPushRate_TextChanged(object sender, EventArgs e)
        {

        }

        private void frmMain_FormClosing(object sender, FormClosingEventArgs e)
        {

        }

        private void radioButton2_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton2.Checked)
            {
                comm.CurrentTransmissionType = CommunicationManager.TransmissionType.Protocol;
                radioButton1.Checked = false;
            }
        }

        private void radioButton1_CheckedChanged(object sender, EventArgs e)
        {
            if (radioButton1.Checked)
            {
                comm.CurrentTransmissionType = CommunicationManager.TransmissionType.Hex;
                radioButton2.Checked = false;
            }
            
        }

        private void copyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                Clipboard.SetText(rtbDisplay.SelectedText.Normalize());
            }
            catch { }

        }
    }
}