﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace PCComm
{

  public class CRC16
  {
      public enum InitialCrcValue { Zeros, NonZero1 = 0xffff, NonZero2 = 0x1D0F }
      const ushort poly = 4129;
      ushort[] table = new ushort[256];
      ushort initialValue = 0;

      // reverse byte order (16-bit)
      public static UInt16 ReverseBytes(UInt16 value)
      {
        return (UInt16)((value & 0xFFU) << 8 | (value & 0xFF00U) >> 8);
      }

      
      /// <summary>
      /// constructor
      /// </summary>
      public CRC16(InitialCrcValue initialValue) 
      {
        this.initialValue = (ushort)initialValue;
        ushort temp, a;
        for(int i = 0; i < table.Length; ++i) {
            temp = 0;
            a = (ushort)(i << 8);
            for(int j = 0; j < 8; ++j) {
                if(((temp ^ a) & 0x8000) != 0) {
                    temp = (ushort)((temp << 1) ^ poly);
                } else {
                    temp <<= 1;
                }
                a <<= 1;
            }
            table[i] = temp;
        }
     }

       /// <summary>
       /// 
       /// </summary>
       /// <param name="bytes"></param>
       /// <returns></returns>
       public ushort Compute(byte[] bytes) 
       {
           ushort crc = this.initialValue;
           for (int i = 0; i < bytes.Length; ++i)
           {
               crc = (ushort)((crc << 8) ^ table[((crc >> 8) ^ (0xff & bytes[i]))]);
           }
           return crc;
       }

       /// <summary>
       /// 
       /// </summary>
       /// <param name="bytes"></param>
       /// <returns></returns>
       public byte[] ComputeLowHighByte(byte[] bytes) 
       {
        ushort crc = Compute(bytes);
        return BitConverter.GetBytes(crc);
       }

       /// <summary>
       /// 
       /// </summary>
       /// <param name="bytes"></param>
       /// <returns></returns>
       public byte[] ComputeHighLowByte(byte[] bytes) 
       {
        byte btmp;
        byte [] ba;

        ushort crc = Compute(bytes);
        ba = BitConverter.GetBytes(crc);
        btmp = ba[0];
        ba[0] = ba[1];
        ba[1] = btmp;
        return ba;
       }
    
  }
}
